package com.ejie.ab04b.model.nora;

/**
 * Provincia.
 * 
 * @author GFI
 */
public class Provincia implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String codProvincia;
	private String descripcion;
	private String codAutonomia;

	/**
	 * Method 'Provincia'.
	 */
	public Provincia() {
		super();
	}

	/**
	 * Method 'Provincia'.
	 * 
	 *  codProvincia
	 *            String
	 *
	 * @param codProvincia the cod provincia
	 */
	public Provincia(String codProvincia) {
		super();
		this.codProvincia = codProvincia;
	}

	/**
	 * Method 'Provincia'.
	 * 
	 *  codProvincia
	 *            String
	 *  descripcion
	 *            String
	 *  codAutonomia
	 *            String
	 *
	 * @param codProvincia the cod provincia
	 * @param descripcion the descripcion
	 * @param codAutonomia the cod autonomia
	 */
	public Provincia(String codProvincia, String descripcion, String codAutonomia) {
		super();
		this.codProvincia = codProvincia;
		this.descripcion = descripcion;
		this.codAutonomia = codAutonomia;
	}

	/**
	 * Method 'getCodProvincia'.
	 * 
	 *  String
	 *
	 * @return the cod provincia
	 */
	public String getCodProvincia() {
		return this.codProvincia;
	}

	/**
	 * Method 'setCodProvincia'.
	 * 
	 *  codProvincia
	 *            String
	 *
	 * @param codProvincia the new cod provincia
	 */
	public void setCodProvincia(String codProvincia) {
		this.codProvincia = codProvincia;
	}

	/**
	 * Method 'getDescripcion'.
	 * 
	 *  String
	 *
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return this.descripcion;
	}

	/**
	 * Method 'setDescripcion'.
	 * 
	 *  descripcion
	 *            String
	 *
	 * @param descripcion the new descripcion
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * Method 'getCodAutonomia'.
	 * 
	 *  String
	 *
	 * @return the cod autonomia
	 */
	public String getCodAutonomia() {
		return this.codAutonomia;
	}

	/**
	 * Method 'setCodAutonomia'.
	 * 
	 *  codAutonomia
	 *            String
	 *
	 * @param codAutonomia the new cod autonomia
	 */
	public void setCodAutonomia(String codAutonomia) {
		this.codAutonomia = codAutonomia;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	// @Override()
	public String toStringUDA() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(", [ codProvincia: ").append(this.codProvincia).append(" ]");
		result.append(", [ descripcion: ").append(this.descripcion).append(" ]");
		result.append("[ codAutonomia: ").append(this.codAutonomia).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override()
	public String toString() {
		return this.codProvincia;
	}
}